#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Dec 10 09:07:19 2019

@author: yannbrunel
"""

import numpy as np
import matplotlib.pyplot as plt
#%%
t0, tf = 0., 10. # bornes de l'intervalle de temps pour la résolution
N = 1000 # nombre de pas
t = np.linspace(t0,tf,N+1) # liste des dates pour le calcul des solutions aprochées
T0=300 #intialisation x(0)=0
a=1
c=1
TS=400
def f(T,t): #on définit la fonction f qui correspond à l'équation différentielle
    return -a*(T-TS)/c # la fonction correspond à une loi du type Newton
#%%
def euler(g,x0,t): # méthode d'Euler 
    h = t[1]-t[0] # pas constant, choisi comme distance entre les deux premières valeurs de la liste de t
    N = len(t)  # on recalcule N en local pour le cas général 
    x = np.zeros(N) # intialisation obligatoire du tableau numpy, crée un tableau de longueur N rempli de 0
    x[0] = x0 # initialisation de la résolution
    for i in range(N-1):
        x[i+1] = x[i]+h*g(x[i],t[i]) # définit x[i+1] par Euler
    return x # la boucle précédente sert à calculer les valeurs de x, la fin définit x comme fonction solution de la fonction eurler

#%%
solE = euler(f,300,t) # définit la solution du programme Euler 
plt.figure() #options de tracé
plt.plot(t,solE,'b-',label='Euler avec N = '+str(N))
plt.legend(loc='best') 
plt.xlabel('t') ; plt.ylabel('$T$')
plt.grid()
plt.legend()
plt.show()
